<?php 


include_once 'config.php';
include_once 'infrastructure/bulkgateApiClient.php';

class SMS
{
   /* "application_id": "<APPLICATION_ID>", 
    "application_token": "<APPLICATION_TOKEN>", 
    "number": "7700900000", 
    "text": "test_sms", 
    "unicode": true,
    "sender_id": "gText",
    "sender_id_value": "BulkGate",
    "country": "gb" */

    private string $phoneNumber;
    private string $message;
    //country
    private string $country;
    private string $tag;
    
    
    

   // construtor
    public function __construct(string $phoneNumber, string $message, string $country = "PT", string $tag = "")
    {
        $this->phoneNumber = $phoneNumber;
        $this->message = $message;
        $this->country = $country;
        $this->tag = $tag;
    }

    // Send SMS
    public static function sendSMS(SMS $sms): bool
    {

        // valida as constants caso alguma coisa falhe
        if (empty(BULKGATE_APPLICATION_ID) || empty(BULKGATE_APPLICATION_TOKEN) || empty(BULKGATE_SENDER_ID)) {
            throw new Exception("Erro: As constantes BULKGATE_APPLICATION_ID, BULKGATE_APPLICATION_TOKEN ou BULKGATE_SENDER_ID não estão definidas.");
        }

        $endpoint =  'simple/transactional';
        $data = [
            'application_id' => BULKGATE_APPLICATION_ID,
            'application_token' => BULKGATE_APPLICATION_TOKEN,
            'number' => $sms->getPhoneNumber(),
            'text' => $sms->getMessage(),
            'sender_id' => BULKGATE_SENDER_ID_VALUE,
            'sender_id_value' => BULKGATE_SENDER_ID ,
            'country' => $sms->getCountry(),
            'tag' => $sms->getTag()
        ];

        try {
            // Send the request to the API
            $response = sendSMSRequest($endpoint, $data);
        } catch (Exception $e) {
            throw new Exception("Erro ao enviar SMS: " . $e->getMessage());
        }

        

        // Handle the response as needed
        return self::handleResponse($response);
    }

    // Handle the API response
    private static function handleResponse($response): bool
    {
        // Example implementation: check if the response indicates success
        if (isset($response['status']) && $response['status'] === 'success') {
            return true;
        }
        return false;
    }




    // getPhoneNumber
    public function getPhoneNumber(): string
    {
        return $this->phoneNumber;
    }
    // setPhoneNumber
    public function setPhoneNumber(string $phoneNumber): void
    {
        $this->phoneNumber = $phoneNumber;
    }
    // getMessage
    public function getMessage(): string
    {
        return $this->message;
    }
    // setMessage
    public function setMessage(string $message): void
    {
        $this->message = $message;
    }
    // getCountry
    public function getCountry(): string
    {
        return $this->country;
    }
    // setCountry
    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    // getTag
    public function getTag(): string
    {
        return $this->tag;
    }
    // setTag
    public function setTag(string $tag): void
    {
        $this->tag = $tag;
    }


    
}