<?php

include_once 'core/moloni/documents/invoice.php';
include_once 'core/moloni/entities/customer.php';
include_once 'core/moloni/mbReference/mbReference.php';
include_once 'core/moloni/documents/pdfLink.php';
include_once 'core/moloni/documents/invoice.php';
include_once 'core/bulkgate/sms/sms.php';
include_once 'utils/log.php';
include_once 'config.php'; 



class pendingInvoiceSMS
{

    private string $documento;
    private datetime $dataVencimento;
    private string $linkPdf;
    private string $codigoCliente;
    private string $nomeCliente;
    private string $telefoneCliente;
    private string $nif;
    private string $entidadeMB;
    private string $referenciaMB;
    private string $valor;
    private string $mensagem;

    public function __construct() {}

    public static function getPendingInvoices(): array
    {
        
        
        $finalPendingInvoices =[];
        try{

        
        // retorna já as faturas pendentes
        $pendingInvoices = Invoice::getPendingInvoices();

       

            // Por cada pendente vai ver se o cliente tem uma Flag Ativa

            foreach ($pendingInvoices as $pendente) {

                try{
            
                // Se o cliente tiver a flag ativa, adiciona a pendente ao array final
                
                $client = Customer::getClientById($pendente->getCustomerId());

                // Se o cliente tem Alerta SMS
                if ($client->hasFlag()) { {
                        // Se o cliente tem um número de telefone válido

                        if ($client->checkPhone() != 0) {

                            $mbReference = MBReference::getMbReferenceByDocID($pendente->getDocumentId());
                            if ($mbReference->getEntity()!= "") {

                                $pendenteSMS = self::fromInvoiceToPendingInvoiceSMS($pendente);
                                $pendenteSMS->setTelefoneCliente($client->checkPhone());
                                $pendenteSMS->setEntidadeMB($mbReference->getEntity());
                                $pendenteSMS->setReferenciaMB($mbReference->getFinalReference());
                                $pendenteSMS->setValor($mbReference->getValue());
                            
                                // vai buscar o link pdf
                                $linkPdf = PdfLink::getPDFLink($pendente->getDocumentId());
                                $pendenteSMS->setLinkPdf($linkPdf->getUrl());
                                // Adiciona a pendente ao array final
                                $finalPendingInvoices[]=$pendenteSMS;

                            }
                            else{
                                throw new Exception(" referencia MB da fatura em branco " . $pendente->getDocumentId());
                            }
                        }
                    }
                }

            }
                catch (Exception $e) {
                    writeLog("\Erro ao tratar pendente: " . $e->getMessage(). "\n". $pendente->__toString());
                    continue;
                }
            }

        }
        catch (Exception $e) {
            throw new Exception(  $e->getMessage());
        }

        return $finalPendingInvoices;
    }


    public static function sendSMS($pendentes): bool
    {
        $sucesso = true;

        // Se não houver pendentes, retorna true
        if (empty($pendentes)) {
            return $sucesso;
        }

        if (FORCE_NUMBER!=""){
            $pendentes= array_slice($pendentes, 0, 1);
        }

        // Para cada pendente, envia o SMS
        foreach ($pendentes as $pendente) {

            try {
                
            $mensagem = $pendente->__toString();
            $telefone = FORCE_NUMBER!=""?FORCE_NUMBER: $pendente->getTelefoneCliente();
            
            $tag= $pendente->getNif()." - ".$pendente->getNomeCliente();
       
            $sms= new SMS(
             $telefone,
               $mensagem,'PT',
               $tag
            );

            // Envia o SMS
            $response = SMS::sendSMS($sms);

            // escreve log da mensagem que foi enviada com nif, nome cliente e fatura
            writeLog("SMS enviado para " . $pendente->getNomeCliente() . " - " . $pendente->getNif() . " - " . $pendente->getDocumento() . " - " . $pendente->getTelefoneCliente() . " - " . $pendente->getLinkPdf() . "\n" . $mensagem);



            } catch (Exception $e) {
                writeLog(" Erro ao enviar SMS: " . $e->getMessage());
                continue;
            }

        }

        return $sucesso;
    }

    // convert array de Invoice para PendingInvoiceSMS

    public static function fromInvoiceToPendingInvoiceSMS(Invoice $invoice): pendingInvoiceSMS
    {
        try {
            $pendente = new pendingInvoiceSMS();
            $pendente->setDocumento("Fatura " . $invoice->getDocumentSetName() . "/" . $invoice->getDocumentNumber());
            $pendente->setDataVencimento($invoice->getExpirationDate());
            $pendente->setCodigoCliente($invoice->getEntityNumber());
            $pendente->setNomeCliente($invoice->getEntityName());
            $pendente->setNif($invoice->getEntityVat());
        } catch (Exception $e) {
            throw new Exception("Erro ao  converte Pendente fromInvoiceToPendingInvoiceSMS : " . $e->getMessage());
        }
       
        return $pendente;
    }



    public function getDocumento(): string
    {
        return $this->documento;
    }
    public function setDocumento(string $documento): void
    {
        $this->documento = $documento;
    }
    public function getDataVencimento(): datetime
    {
        return $this->dataVencimento;
    }
    public function setDataVencimento(datetime $dataVencimento): void
    {
        $this->dataVencimento = $dataVencimento;
    }
    public function getLinkPdf(): string
    {
        return $this->linkPdf;
    }
    public function setLinkPdf(string $linkPdf): void
    {
        $this->linkPdf = $linkPdf;
    }
    public function getCodigoCliente(): string
    {
        return $this->codigoCliente;
    }
    public function setCodigoCliente(string $codigoCliente): void
    {
        $this->codigoCliente = $codigoCliente;
    }
    public function getNomeCliente(): string
    {
        return $this->nomeCliente;
    }
    public function setNomeCliente(string $nomeCliente): void
    {
        $this->nomeCliente = $nomeCliente;
    }
    public function getTelefoneCliente(): string
    {
        return $this->telefoneCliente;
    }
    public function setTelefoneCliente(string $telefoneCliente): void
    {
        $this->telefoneCliente = $telefoneCliente;
    }
    public function getNif(): string
    {
        return $this->nif;
    }
    public function setNif(string $nif): void
    {
        $this->nif = $nif;
    }
    public function getEntidadeMB(): string
    {
        return $this->entidadeMB;
    }
    public function setEntidadeMB(string $entidadeMB): void
    {
        $this->entidadeMB = $entidadeMB;
    }
    public function getReferenciaMB(): string
    {
        return $this->referenciaMB;
    }
    public function setReferenciaMB(string $referenciaMB): void
    {
        $this->referenciaMB = $referenciaMB;
    }
    public function getValor(): string
    {
        return $this->valor;
    }
    public function setValor(string $valor): void
    {
        $this->valor = $valor;
    }
    public function getMensagem(): string
    {
        return $this->mensagem;
    }
    public function setMensagem(string $mensagem): void
    {
        $this->mensagem = $mensagem;
    }


     //To string
    public function __toString(): string
    {
        return      
        //subti da string que esssta em baixo
        "Fama Radio e Televisao / Opiniao Publica relembra $this->nomeCliente que a $this->documento venceu a ".$this->dataVencimento->format('d/m/Y')." .\n".
        "Pague via MB\n\n".
       
       "Entidade : $this->entidadeMB \n".
        "Referencia:  $this->referenciaMB \n".
        "Valor: $this->valor EUR\n\n".

        "Consulte Fatura: $this->linkPdf\n\n".

        "Se ja pagou, ignore mensagem.\n". 
        
        "Obrigado, Editave Lda"

        ;


     
        
        
    }
}
