<?php

include_once 'infrastructure/moloniApiClient.php';
include_once 'core/moloni/account/auth.php';
include_once 'config.php';
//inclui o log
include_once 'utils/log.php';

class Invoice
{
    private int $document_id;
    private  int $document_number;
    private int $document_type_id;
    private string $document_type_code="FT";
    private int $document_set_id;
    private string $document_set_name;
    private datetime $expiration_date;
    private int $customer_id;
    private string $entity_number;
    private string $entity_name;
    private string $entity_vat;
    private int $status;
    private float $net_value;
    private float $reconciled_value;

    //construtor
    public function __construct(int $document_id, int $document_number, int $document_type_id, int $document_set_id, string $document_set_name, datetime $expiration_date, int $customer_id, string $entity_number, string $entity_name, string $entity_vat,int $status = 0, float $net_value = 0, float $reconciled_value = 0)
    {
        $this->document_id = $document_id;
        $this->document_number = $document_number;
        $this->document_type_id = $document_type_id;
        $this->document_set_id = $document_set_id;
        $this->document_set_name = $document_set_name;
        $this->expiration_date = $expiration_date;
        $this->customer_id = $customer_id;
        $this->entity_number = $entity_number;
        $this->entity_name = $entity_name;
        $this->entity_vat = $entity_vat;
        $this->status = $status;
        $this->net_value = $net_value;
        $this->reconciled_value = $reconciled_value;
    }

    //construtor vazio
    public function __constructEmpty()
    {
        $this->document_id = 0;
        $this->document_number = 0;
        $this->document_type_id = 0;
        $this->document_set_id = 0;
        $this->document_set_name = "";
        $this->expiration_date = new DateTime();
        $this->customer_id = 0;
        $this->entity_number = "";
        $this->entity_name = "";
        $this->entity_vat = "";
        $this->status = 0;

    }

    //getPendingInvoices
    public static function getPendingInvoices(): array
    {   

        $page = 0;
        $perPage = 50;
        $endpoint = 'documents/getAll/';
        $invoices = [];
        $invoicesjson= null;

        do {

            $data = [
                'company_id' => COMPANY_ID,
                'document_type_id' => INVOICE_DOCUMENT_TYPE_ID,
                'status' => INVOICE_PENDING_STATUS,
                'offset' => $page * $perPage,
                'qty' => $perPage,
            ];

            try {
               
            $invoicesjson = sendRequest($endpoint, $data);

            } catch (Exception $e) {
                throw new Exception("Erro ao obter invoices: " . $e->getMessage());
                break;
            } 

            try {
             
         
            // Verifica se o json é um array
            
            $newinvoices = self::fromJsonArray($invoicesjson);


            
            // filtra os invoices para só ter os pendentes
            $newinvoices_ = array_filter($newinvoices, function ($invoice) {
                // filtra os invoices para só ter os pendentes
                // se o valor total - valor reconciliado for maior que 0

                if ($invoice->getNetValue()-$invoice->getReconciledValue() > 0) {
                    // verificar data de vencimento
                    $currentDate = new DateTime();
                    $expirationDate = new DateTime($invoice->getExpirationDate()->format('Y-m-d'));
                    
                    // se a data de vencimento for menor que a data atual
                    if ($expirationDate > $currentDate) {
                        return false;
                    }else{

                        $passed_days = $currentDate->diff($expirationDate)->days;

                        $multuple3 = $passed_days % 3;

                        if ($multuple3 == 0) {
                            return true;
                        }else{
                            return false;
                        }
                    }
                }else{
                    return false;
                }
               
            });
            
            $invoices = array_merge($invoices, $newinvoices_);

        } catch (Exception $e) {

            throw new Exception("Erro ao tratar invoices: " . $e->getMessage(). "\n" . json_encode($invoicesjson));
            break;
        }

            $page++;
        } while (count($newinvoices)===$perPage);

    
        return $invoices;
    }

    



    // json para object

    public static function fromJson($json): Invoice
    {
        $data = json_decode($json, true);
        return new Invoice(
            $data['document_id'],
            $data['document_number'],
            $data['document_type_id'],
            $data['document_set_id'],
            $data['document_set_name'],
            new DateTime($data['expiration_date']),
            $data['customer_id'],
            $data['entity_number'],
            $data['entity_name'],
            $data['entity_vat'],
            $data['status'],
            $data['net_value'],
            $data['reconciled_value']
        );
    }


    // json Array array objetc

    public static function fromJsonArray($json): array
    {
        $data = json_decode($json, true);
        $invoices = [];
        foreach ($data as $item) {
            $invoice = new Invoice(
                $item['document_id'],
                $item['number'],
                $item['document_type_id'],
                $item['document_set_id'],
                $item['document_set_name'],
                new DateTime($item['expiration_date']),
                $item['customer_id'],
                $item['entity_number'],
                $item['entity_name'],
                $item['entity_vat'],
                $item['status'],
                $item['net_value'],
                $item['reconciled_value']
            );

            $invoices[]=($invoice);
        }
        return $invoices;
    }

    //trata nif PT505468310_C 
    public static function formatNif(string $nif): string
    {
        $nif = preg_replace('/[^0-9]/', '', $nif); // Remove all non-numeric characters
        return $nif;
    }


    //getters
    public function getDocumentId(): int
    {
        return $this->document_id;
    }
    public function getDocumentNumber(): int
    {
        return $this->document_number;
    }
    public function getDocumentTypeId(): int
    {
        return $this->document_type_id;
    }
    public function getDocumentTypeCode(): string
    {
        return $this->document_type_code;
    }
    public function getDocumentSetId(): int
    {
        return $this->document_set_id;
    }
    public function getDocumentSetName(): string
    {
        return $this->document_set_name;
    }
    public function getExpirationDate(): datetime
    {
        return $this->expiration_date;
    }
    public function getCustomerId(): int
    {
        return $this->customer_id;
    }
    public function getEntityNumber(): string
    {
        return $this->entity_number;
    }
    public function getEntityName(): string
    {
        return $this->entity_name;
    }
    public function getEntityVat(): string
    {
        return $this->entity_vat;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
    public function getNetValue(): float
    {
        return $this->net_value;
    }
    public function getReconciledValue(): float
    {
        return $this->reconciled_value;
    }
    //setters
    public function setDocumentId(int $document_id): void
    {
        $this->document_id = $document_id;
    }
    public function setDocumentNumber(int $document_number): void
    {
        $this->document_number = $document_number;
    }
    public function setDocumentTypeId(int $document_type_id): void
    {
        $this->document_type_id = $document_type_id;
    }
    public function setDocumentTypeCode(string $document_type_code): void
    {
        $this->document_type_code = $document_type_code;
    }
    public function setDocumentSetId(int $document_set_id): void
    {
        $this->document_set_id = $document_set_id;
    }
    public function setDocumentSetName(string $document_set_name): void
    {
        $this->document_set_name = $document_set_name;
    }
    public function setExpirationDate(datetime $expiration_date): void
    {
        $this->expiration_date = $expiration_date;
    }
    public function setCustomerId(int $customer_id): void
    {
        $this->customer_id = $customer_id;
    }
    public function setEntityNumber(string $entity_number): void
    {
        $this->entity_number = $entity_number;
    }
    public function setEntityName(string $entity_name): void
    {
        $this->entity_name = $entity_name;
    }
    public function setEntityVat(string $entity_vat): void
    {
        $this->entity_vat = $entity_vat;
    }
    public function setStatus(int $status): void
    {
        $this->status = $status;
    }
    public function setNetValue(float $net_value): void
    {
        $this->net_value = $net_value;
    }
    public function setReconciledValue(float $reconciled_value): void
    {
        $this->reconciled_value = $reconciled_value;
    }


    public function __toString(): string
    {
        return "Document ID: {$this->document_id}, Document Number: {$this->document_number}, Document Type ID: {$this->document_type_id}, Document Set ID: {$this->document_set_id}, Document Set Name: {$this->document_set_name}, Expiration Date: {$this->expiration_date->format('Y-m-d')}, Customer ID: {$this->customer_id}, Entity Number: {$this->entity_number}, Entity Name: {$this->entity_name}, Entity VAT: {$this->entity_vat}, Status: {$this->status}, Net Value: {$this->net_value}, Reconciled Value: {$this->reconciled_value}";
    }


 
    
    
}



?>