<?php

include_once 'infrastructure/shortLinkApiClient.php';

class PdfLink
{

    private string $url;
   
    //coonstrutor
    public function __construct(string $url,int $documentId)
    {
    
   
        try {
           $newurl= sendShortLinkRequest("?url=".$url."&documentid=".$documentId);
           
        } catch (Exception $e) {
            $newurl = $url;
            throw new Exception("Erro ao decodificar a URL: " . $e->getMessage());
        }

        $this->url =$newurl['shortened']??$url;
    }
    

    public static function getPdfLink($documentId): PdfLink
    {
        $endpoint = 'documents/getPdfLink/';
        $data = [
            'company_id' => COMPANY_ID,
            'document_id' => $documentId
        ];
        
        try {
            $json = sendRequest($endpoint, $data);
        } catch (Exception $e) {
                throw   new Exception("Erro ao obter o link do PDF: " . $e->getMessage());      
                
        }

        
        try {
            $PDFLink = self::jsonToPdfLink($json,$documentId);
        } catch (Exception $e) {
            throw new Exception("Erro ao converter JSON para link do PDF  : " . $e->getMessage());
        }

      

        
        return $PDFLink;
    }  


    

    //From JSON to PdfLink
    public static function jsonToPdfLink($json,$documentId): PdfLink
    {
        $json= json_decode($json,true);
        $url = $json['url']??"0";
        
        return new PdfLink($url,$documentId);
    }



    public function getUrl(): string
    {
        return $this->url;
    }

    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

    
}   
