<?php

include_once 'utils/log.php';

class MBReference
{

    private string $entity;
    private string $sub_entity;
    private string $reference;
    private string $check_digits;
    private string $final_reference;
    private float $value;

    //construtor

    public function __construct(string $entity, string $sub_entity, string $reference, string $check_digits, float $value, string $final_reference ="")
    {
        $this->entity = $entity;
        $this->sub_entity = $sub_entity;
        $this->reference = $reference;
        $this->check_digits = $check_digits;
        $this->final_reference = $final_reference;
        $this->value = $value;
    }
   
    // getMbReference
    public static function getMbReferenceByDocID($documentId): MBReference
    {
        $endpoint = 'documents/getOne/';
        $data = [
            'company_id' => COMPANY_ID,
            'document_id' => $documentId
        ];
        
        try {
            $doc = sendRequest($endpoint, $data);
        } catch (Exception $e) {
            throw new Exception("Erro ao obter a referência multibanco: " . $e->getMessage());
        }
 
        try {

         $mbReference = MBReference::jsonToMBReference($doc);

        } catch (Exception $e) {
            throw new Exception("Erro ao converter JSON para referência multibanco: " . $e->getMessage());
        }


        return $mbReference;
    }

    //From JSON to MBReference
    public static function jsonToMBReference($json): MBReference
    {
      
        $json= json_decode($json,true);


        $entity = $json['mb_references'][0]['entity']??"0";
        $sub_entity = $json['mb_references'][0]['sub_entity']??"0";
        $reference = $json['mb_references'][0]['reference']??"0";
        $check_digits = $json['mb_references'][0]['check_digits']??"0";
        $value = $json['mb_references'][0]['value']??0;

         $Reference= new MBReference($entity, $sub_entity, $reference, $check_digits, $value);

        $Reference->generateFinalReference();

        return $Reference;
    }

    public function generateFinalReference():void
    {   
        // Verifica se os valores estão definidos
        if (empty($this->entity) || empty($this->sub_entity) || empty($this->reference) || empty($this->check_digits)) {
            throw new Exception("Os valores da referência multibanco não estão definidos");
        }
        // Verifica se os valores são válidos
        if (!is_numeric($this->entity) || !is_numeric($this->sub_entity) || !is_numeric($this->reference) || !is_numeric($this->check_digits)) {
            throw new Exception("Os valores da referência multibanco não são válidos");
        }

        $this->final_reference = str_pad($this->sub_entity,3,'0',STR_PAD_LEFT) . str_pad($this->reference, 4, '0', STR_PAD_LEFT) . str_pad($this->check_digits, 2, '0', STR_PAD_LEFT);
       
    }

    //getters
    public function getEntity(): string
    {
        return $this->entity;
    }
    public function getSubEntity(): string
    {
        return $this->sub_entity;
    }
    public function getReference(): string
    {
        return $this->reference;
    }
    public function getCheckDigits(): string
    {
        return $this->check_digits;
    }
    public function getValue(): float
    {
        return $this->value;
    }
    public function getFinalReference(): string
    {
        return $this->final_reference ;
    }
    //setters
    public function setEntity(string $entity): void
    {
        $this->entity = $entity;
    }
    public function setSubEntity(string $sub_entity): void
    {
        $this->sub_entity = $sub_entity;
    }
    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }
    public function setCheckDigits(string $check_digits): void
    {
        $this->check_digits = $check_digits;
    }
    public function setValue(float $value): void
    {
        $this->value = $value;
    }
    public function setFinalReference(string $final_reference): void
    {
        $this->final_reference = $final_reference;
    }
    public function __toString(): string
    {
        return "Entity: " . $this->entity . "\n" .
            "Sub Entity: " . $this->sub_entity . "\n" .
            "Reference: " . $this->reference . "\n" .
            "Check Digits: " . $this->check_digits . "\n" .
            "Value: " . $this->value . "\n";
    }
    
}
