<?php


function sendSMSRequest($endpoint, $data = []) {
   
    
    $headers = ['Content-Type: application/x-www-form-urlencoded'];


    // verifica se está tudo definido Api_URL
    if (!defined('BULKGATE_API_URL')) {
        throw new Exception('A constante API_URL deve ser definida.');
    }

    // Verifica se endpoint está definido
    if (empty($endpoint)) {
        throw new Exception('O endpoint deve ser definido.');
    }


    $url=BULKGATE_API_URL .  $endpoint;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);

    //$jsonData=json_encode($data);
    //preciso de dar encode a  $data para x-www-form-urlencoded

    $data = http_build_query($data);
    //echo $data;

    curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        throw new Exception("Erro de conexão: $curlError");
    }

    if ($httpCode >= 400) {
        throw new Exception("Erro HTTP $httpCode: " . json_encode($response));
    }
  
    return json_decode($response, true);
}



?>