<?php

// Incluir arquivos necessários
include_once 'utils/log.php';
include_once 'core/internal/pendingInvoicesSMS.php';  // Exemplo de inclusão de funcionalidades relacionadas aos pendentes


// Classe para orquestrar o fluxo do programa
class SMSIntegration
{


    // Função principal que orquestra as ações
    public static function main()
    {

        self::createLog();  // Cria o log

        // Chama a função de log do arquivo 'utils/log.php'
        writeLog("Início do envio de SMSs");  // Escreve no log
        

        $pendentes = self::getPendentes();  // Obtém as pendentes

        // Se não houver pendentes, sai
        if (empty($pendentes)) {
            writeLog("Não há faturas pendentes para enviar SMSs.");
            return;
        }



        // Se houver pendentes, envia os SMSs
        writeLog("Faturas pendentes encontradas: " . count($pendentes));  // Escreve no log
        writeLog("Enviando SMSs...");  // Escreve no log
       //self::sendSMS($pendentes);  // Envia SMS

        writeLog("Envio de SMSs concluído");  // Escreve no log

        die();  // Encerra o script
    }


    // Função para criar logs
    public static function createLog()
    {
        createLogFile();  // Chama a função de log do arquivo 'utils/log.php'
    }

    // Função para pegar as faturas pendentes
    public static function getPendentes()
    {
        return pendingInvoiceSMS::getPendingInvoices();  // Supondo que essa função está definida em 'core/internal/pendingInvoices.php'
    }

    // Função para enviar SMSs
    public static function sendSMS($pendentes)
    {
        return pendingInvoiceSMS::sendSMS($pendentes);  // Função de envio de SMS definida em 'core/bulkgate/sms/sms.php'
    }
}



// Chamada para a função principal
SMSIntegration::main();
